/****** Object:  View [dbo].[V_DESCONTO_ESTRATO]    Script Date: 04/11/2013 10:05:53 ******/
IF  EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[V_DESCONTO_ESTRATO]'))
DROP VIEW [dbo].[V_DESCONTO_ESTRATO]
GO
--SELECT * FROM V_DESCONTO_ESTRATO WHERE DT_VD = '2018-11-01' AND CD_EMP =1 AND CD_FILIAL = 2
CREATE VIEW [dbo].[V_DESCONTO_ESTRATO]
AS
SELECT     
	A.DT_VD, 
	A.CD_EMP, 
	A.CD_FILIAL, 
	0 AS NR_ECF,
	0 AS CD_VD,
	0 AS CD_IT,
	A.CD_PROD, 
	P.DS_PROD, 
	A.TIPO_DESCONTO,
	F.CD_FABRIC, 
	F.NM_FABRIC, 
	L.CD_ARV_MERC_LINHA, 
	L.DS_ARV_MERC_LINHA, 
	A.CD_VEND,
	A.NM_FUN, 
	SUM(QT_IT) VDA_UN, 
	SUM(TOT_IT) VDA_LIQ_VLR, 
	SUM(ISNULL(VLR_PMC_TOTAL,0)) VDA_PMC, 
	SUM(VLR_CUSTO_BRUTO) VDA_CUSTO, 
	AVG(VLR_IT) VLR_SKU_MD,
	SUM(DESC_FIDEL_MIN) DESC_FIDEL_MIN,
	SUM(DESC_FIDEL_MAIOR_MIN) DESC_FIDEL_MAIOR_MIN,
	SUM(TX_DESC) TX_DESC_MD_APLIC, 
	SUM([DESCONTO PMC]) DESCONTO_PMC,
	SUM([DESCONTO VERBA]) DESCONTO_VERBA, 
	SUM([DESCONTO LOJA]) DESCONTO_LOJA, 
	SUM([DESCONTO VALOR FIDELIDADE]) DESCONTO_VALOR_FIDELIDADE, 
	SUM([SEM DESCONTO]) SEM_DESCONTO, 
	SUM([DESCONTO CADASTRO PRODUTO]) DESCONTO_CADASTRO_PRODUTO, 
	SUM([DESCONTO CONVENIO]) DESCONTO_CONVENIO, 
	SUM([DESCONTO FIDELIDADE]) DESCONTO_FIDELIDADE, 
    SUM([DESCONTO PBM]) DESCONTO_PBM, 
	SUM([DESCONTO OFERTA]) DESCONTO_OFERTA, 
	SUM([DESCONTO CUPONAGEM]) DESCONTO_CUPONAGEM, 
	SUM([DESCONTO CRM]) DESCONTO_CRM, 
	SUM([DESCONTO POR TROCA DE PONTOS]) DESCONTO_POR_TROCA_DE_PONTOS, 
	SUM([DESCONTO ANIVERSARIO]) DESCONTO_ANIVERSARI0, 
	SUM([DESCONTO POR CLASSIFICACAO DE CLIENTE]) DESCONTO_POR_CLASSIFICACAO_DE_CLIENTE, 
	SUM([ERRO SEM CLASSIFICACAO]) ERRO_SEM_CLASSIFICACAO,	
	SUM([DESCONTO PRECO DE FABRICA]) DESCONTO_PRECO_DE_FABRICA, 
	SUM([DESCONTO POR QUANTIDADE]) DESCONTO_POR_QUANTIDADE,
	SUM([DESCONTO PROMOCAO NO TELEVENDAS]) DESCONTO_PROMOCAO_NO_TELEVENDAS,
	SUM([DESCONTO CONVENIO COM RECEITA]) DESCONTO_CONVENIO_COM_RECEITA,
	SUM([DESCONTO BRINDE]) as DESCONTO_BRINDE,
	SUM([DESCONTO FORMA DE PAGAMENTO]) as DESCONTO_FORMA_DE_PAGAMENTO,
	SUM([DESCONTO CREDIARIO]) as DESCONTO_CREDIARIO,
	SUM([DESCONTO CAMPANHA]) as DESCONTO_CAMPANHA,
	SUM([DESCONTO CONVENIO CUSTOMIZADO]) as DESCONTO_CONVENIO_CUSTOMIZADO,
	SUM([DESCONTO MEDICAMENTO GRATUITO]) as DESCONTO_MEDICAMENTO_GRATUITO,
	SUM([DESCONTO PROGRAMADO]) as DESCONTO_PROGRAMADO,
	SUM([DESCONTO PAGUE LEVE]) as DESCONTO_PAGUE_LEVE,
	SUM([DESCONTO FINANCEIRO NOTA FISCAL]) as DESCONTO_FINANCEIRO_NOTA_FISCAL,
	SUM([DESCONTO PRE-VENCIDO]) as DESCONTO_PRE_VENCIDO,
	SUM([DESCONTO POS-PBM]) as DESCONTO_POS_PBM,
	SUM([DESCONTO ESPECIAL LISTA DE PRODUTOS CLIENTE]) as DESCONTO_ESPECIAL_LISTA_DE_PRODUTOS_CLIENTE,
	SUM([DESCONTO CONVENIO/CREDIARIO FORMA DE PGTO]) as DESCONTO_CONVENIO_CREDIARIO_FORMA_DE_PGTO,
	P.LISTA_PROD
FROM         
	(SELECT     
		I.CD_EMP, 
		I.CD_FILIAL, 
		I.CD_PROD,
		I.DT_VD, 
		I.QT_IT, 
		I.TOT_IT, 
		I.TIPO_DESCONTO, 
		(I.QT_IT*I.VLR_PMC) AS VLR_PMC_TOTAL, 
		(QT_IT * VLR_CUSTO_MEDIO) VLR_CUSTO_BRUTO, 
		VLR_IT, 
		TX_DESC,
		I.CD_VEND,
		FP_FUNC.NM_FUN, 		
		CASE WHEN TX_DESC > 0	AND TX_DESC <= PERC_DESC_FIDEL AND TIPO_DESCONTO=4 THEN 
			[DESCONTO FIDELIDADE]
		ELSE 0 END AS DESC_FIDEL_MIN,
 		
		CASE WHEN TX_DESC > 0	AND TX_DESC > PERC_DESC_FIDEL AND TIPO_DESCONTO=4 THEN 
			[DESCONTO FIDELIDADE]
		ELSE 0 END AS DESC_FIDEL_MAIOR_MIN, 
		
		(ROUND(I.QT_IT * I.VLR_IT * I.TX_DESC / 100, 2)) + ISNULL(I.VLR_OFERTA, 0) [DESCONTO PMC],
		I.VLR_DESC_VERBA [DESCONTO VERBA],
		[DESCONTO LOJA], 
		[DESCONTO VALOR FIDELIDADE],
		[SEM DESCONTO], 
		[DESCONTO CADASTRO PRODUTO], 
		[DESCONTO CONVENIO], 
		[DESCONTO FIDELIDADE], 
		[DESCONTO PBM], 
		[DESCONTO OFERTA], 
		[DESCONTO CUPONAGEM], 
		[DESCONTO CRM], 
		[DESCONTO POR TROCA DE PONTOS], 
		[DESCONTO ANIVERSARIO], 
		[DESCONTO POR CLASSIFICACAO DE CLIENTE], 
		[ERRO SEM CLASSIFICACAO],
		[DESCONTO PRECO DE FABRICA], 
		[DESCONTO POR QUANTIDADE],
		[DESCONTO PROMOCAO NO TELEVENDAS],
		[DESCONTO CONVENIO COM RECEITA],
		[DESCONTO BRINDE],
		[DESCONTO FORMA DE PAGAMENTO],
		[DESCONTO CREDIARIO],
		[DESCONTO CAMPANHA],
		[DESCONTO CONVENIO CUSTOMIZADO],
		[DESCONTO MEDICAMENTO GRATUITO],
		[DESCONTO PROGRAMADO],
		[DESCONTO PAGUE LEVE],
		[DESCONTO FINANCEIRO NOTA FISCAL],
		[DESCONTO PRE-VENCIDO],
		[DESCONTO POS-PBM],
		[DESCONTO ESPECIAL LISTA DE PRODUTOS CLIENTE],
		[DESCONTO CONVENIO/CREDIARIO FORMA DE PGTO]
	FROM          
		PDV_VD_IT I INNER JOIN PDV_VD V ON
		I.CD_EMP = V.CD_EMP AND
		I.CD_FILIAL = V.CD_FILIAL AND
		I.CD_VD = V.CD_VD AND
		I.DT_VD = V.DT_VD 
		LEFT JOIN FP_FUNC ON 
		I.CD_EMP = FP_FUNC.CD_EMP AND 
		I.CD_VEND = FP_FUNC.CD_FUN 
		LEFT JOIN V_PDV_VD_IT_EXT_DESC ESTRATO_DESC ON 
		I.CD_EMP = ESTRATO_DESC.CD_EMP AND 
		I.CD_FILIAL = ESTRATO_DESC.CD_FILIAL AND 
		I.CD_VD = ESTRATO_DESC.CD_VD AND
		I.CD_IT = ESTRATO_DESC.CD_IT AND
		I.CD_VEND = ESTRATO_DESC.CD_VEND AND	
		I.CD_PROD = ESTRATO_DESC.CD_PROD
	WHERE
		V.ST_VD=0
		AND I.ST_IT=1
		AND I.CD_EMP =1
		
		) A LEFT JOIN EST_PROD P ON 
		A.CD_PROD = P.CD_PROD AND 
		A.CD_EMP = P.CD_EMP  
		INNER JOIN EST_PROD_FABRIC F ON 
		P.CD_FABRIC = F.CD_FABRIC 

		INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA ARV ON	
		P.CD_PROD = ARV.CD_PROD AND 
		P.CD_EMP = ARV.CD_EMP 

		INNER JOIN EST_ARV_MERC_LINHA L ON 
		ARV.CD_ARV_MERC_LINHA = L.CD_ARV_MERC_LINHA AND 
		ARV.CD_EMP = L.CD_EMP
GROUP BY
	A.CD_EMP, 
	A.DT_VD, 
	--A.CD_VD, 
	A.CD_VEND,
	A.CD_PROD, 
	--A.NR_ECF,
	--A.CD_IT,
	A.CD_FILIAL, 
	A.TIPO_DESCONTO,
	P.DS_PROD, 
	P.LISTA_PROD, 
	A.NM_FUN, 
	F.CD_FABRIC, 
	F.NM_FABRIC, 
	L.DS_ARV_MERC_LINHA,	
	L.CD_ARV_MERC_LINHA
GO


